package five.itcast.cn;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import five.itcast.cn.player.AiFactory;
import five.itcast.cn.player.concrete.HumanPlayer;
import five.itcast.cn.player.interfaces.IPlayer;

//P
public class Chessboard extends View implements IChessboard {

	// [B
	// ќʂã_
	private static final int READY = 1;
	// _
	private static final int RUNNING = 2;
	// ѽY
	private static final int PLAYER_TWO_LOST = 3;
	private static final int PLAYER_ONE_LOST = 4;

	// ǰBĬJ_֠B
	private int currentMode = READY;

	// P
	private final Paint paint = new Paint();

	// Gɫ
	private static final int GREEN = 0;
	private static final int NEW_GREEN = 1;

	// tɫ
	private static final int RED = 2;
	// Sɫ
	private static final int NEW_RED = 3;

	// cС
	private static int pointSize = 20;

	// ʾݔAıؼ
	private TextView textView = null;

	// ͬɫBigmapM
	private Bitmap[] pointArray = new Bitmap[4];

	// Ļ½ǵֵֵ
	private static int maxX;
	private static int maxY;

	// һcƫxϽǏ񔵣P
	private static int yOffset;
	private static int xOffset;

	// ɂ
	// һĬJ
	private IPlayer player1 = new HumanPlayer();
	// ڶtx˙C߀ǌģʽʼ
	private IPlayer player2;
	// Aȳʼɂڶ
	// X
	private static final IPlayer computer = AiFactory.getInstance(2);
	// 
	private static final IPlayer human = new HumanPlayer();

	// δµĿհc
	private final List<Point> allFreePoints = new ArrayList<Point>();

	public Chessboard(Context context, AttributeSet attrs) {
		super(context, attrs);
		setFocusable(true);

		// ɫcʂãK딵M
		Resources r = this.getContext().getResources();
		fillPointArrays(GREEN, r.getDrawable(R.drawable.green_point));
		fillPointArrays(NEW_GREEN, r.getDrawable(R.drawable.new_green_point));
		fillPointArrays(RED, r.getDrawable(R.drawable.red_point));
		fillPointArrays(NEW_RED, r.getDrawable(R.drawable.new_red_point));

		// Oîrõɫ
		paint.setColor(Color.LTGRAY);
	}

	// ʼMQĔĿ
	@Override
	protected void onSizeChanged(int w, int h, int oldw, int oldh) {
		maxX = (int) Math.floor(w / pointSize);
		maxY = (int) Math.floor(h / pointSize);

		// OXY΢{ֵĿ
		xOffset = ((w - (pointSize * maxX)) / 2);
		yOffset = ((h - (pointSize * maxY)) / 2);
		// Pϵľl
		createLines();
		// ʼPпհc
		createPoints();
	}

	// aPеľ
	private void createLines() {
		for (int i = 0; i <= maxX; i++) {// Q
			lines.add(new Line(xOffset + i * pointSize - pointSize / 2,
					yOffset, xOffset + i * pointSize - pointSize / 2, yOffset
							+ maxY * pointSize));
		}
		for (int i = 0; i <= maxY; i++) {// M
			lines.add(new Line(xOffset,
					yOffset + i * pointSize - pointSize / 2, xOffset + maxX
							* pointSize, yOffset + i * pointSize - pointSize
							/ 2));
		}
	}

	// P
	private List<Line> lines = new ArrayList<Line>();

	private void drawChssboardLines(Canvas canvas) {
		for (Line line : lines) {
			canvas.drawLine(line.xStart, line.yStart, line.xStop, line.yStop,
					paint);
		}
	}

	// 
	class Line {
		float xStart, yStart, xStop, yStop;

		public Line(float xStart, float yStart, float xStop, float yStop) {
			this.xStart = xStart;
			this.yStart = yStart;
			this.xStop = xStop;
			this.yStop = yStop;
		}
	}

	// c
	private void drawPoint(Canvas canvas, Point p, int color) {
		canvas.drawBitmap(pointArray[color], p.x * pointSize + xOffset, p.y
				* pointSize + yOffset, paint);
	}

	// O\РB
	public void setMode(int newMode) {
		currentMode = newMode;
		if (currentMode == PLAYER_TWO_LOST) {
			// ʾ2ݔ
			textView.setText(R.string.player_two_lost);
			currentMode = READY;
		} else if (currentMode == RUNNING) {
			textView.setText(null);
		} else if (currentMode == READY) {
			textView.setText(R.string.mode_ready);
		} else if (currentMode == PLAYER_ONE_LOST) {
			// ʾ1ݔ
			textView.setText(R.string.player_one_lost);
			currentMode = READY;
		}
	}

	// Oʾؼ
	public void setTextView(TextView textView) {
		this.textView = textView;
	}

	// O IP¼
	@Override
	public boolean onKeyDown(int keyCode, KeyEvent msg) {
		if (currentMode == READY
				&& (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT || keyCode == KeyEvent.KEYCODE_DPAD_LEFT)) {
			if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {// I˙C
				player2 = computer;
			} else if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {// I--ˌ
				player2 = human;
			}
			restart();
			setMode(RUNNING);
		} else if (currentMode == RUNNING
				&& keyCode == KeyEvent.KEYCODE_DPAD_DOWN) {// _ʼ
			restart();
			setMode(READY);
		} else {
			return false;
		}
		return true;
	}

	// |cҵc
	private Point newPoint(Float x, Float y) {
		Point p = new Point(0, 0);
		for (int i = 0; i < maxX; i++) {
			if ((i * pointSize + xOffset) <= x
					&& x < ((i + 1) * pointSize + xOffset)) {
				p.setX(i);
			}
		}
		for (int i = 0; i < maxY; i++) {
			if ((i * pointSize + yOffset) <= y
					&& y < ((i + 1) * pointSize + yOffset)) {
				p.setY(i);
			}
		}
		return p;
	}

	// _ʼ
	private void restart() {
		createPoints();
		player1.setChessboard(this);
		player2.setChessboard(this);
		setPlayer1Run();
		// ˢһ
		refressCanvas();
	}

	// Ƿ_
	private boolean hasStart() {
		return currentMode == RUNNING;
	}

	// ̎|¼
	@Override
	public boolean onTouchEvent(MotionEvent event) {
		// ߀]_֣ǰ¼ֻ̎̎_|¼
		if (!hasStart() || event.getAction() != MotionEvent.ACTION_UP) {
			return true;
		}
		// Ƿ̎һ^
		if (onProcessing()) {
			return true;
		}

		playerRun(event);

		return true;
	}

	private synchronized void playerRun(MotionEvent event) {
		if (isPlayer1Run()) {// һ
			player1Run(event);
		} else if (isPlayer2Run()) {// ڶ
			player2Run(event);
		}
	}

	private void player1Run(MotionEvent event) {
		Point point = newPoint(event.getX(), event.getY());
		if (allFreePoints.contains(point)) {// Ƿ
			setOnProcessing();
			player1.run(player2.getMyPoints(), point);
			// playerOnePoints.add(point);
			// ˢһP
			refressCanvas();
			// ДһǷѽ
			if (!player1.hasWin()) {// ߀]A
				if (player2 == computer) {// ڶX
				// 10Žo2
					refreshHandler.computerRunAfter(10);
				} else {
					setPlayer2Run();
				}
			} else {
				// tʾ[Y
				setMode(PLAYER_TWO_LOST);
			}
		}
	}

	private void player2Run(MotionEvent event) {
		Point point = newPoint(event.getX(), event.getY());
		if (allFreePoints.contains(point)) {// Ƿ
			setOnProcessing();
			player2.run(player1.getMyPoints(), point);
			// playerTwoPoints.add(point);
			// ˢһP
			refressCanvas();
			// ДǷA
			if (!player2.hasWin()) {// ߀]A
				setPlayer1Run();
			} else {
				// tʾ[Y
				setMode(PLAYER_ONE_LOST);
			}
		}
	}

	private RefreshHandler refreshHandler = new RefreshHandler();

	class RefreshHandler extends Handler {

		// @Ҫָĕr̰lһϢ
		public void computerRunAfter(long delayMillis) {
			this.removeMessages(0);
			// lϢ|lhandleMessage
			sendMessageDelayed(obtainMessage(0), delayMillis);
		}

		// յϢ
		@Override
		public void handleMessage(Message msg) {
			// Xһ
			player2.run(player1.getMyPoints(), null);
			// ˢһ
			refressCanvas();
			if (!player2.hasWin()) {
				// 
				setPlayer1Run();
			} else {// ڶA
				setMode(PLAYER_ONE_LOST);
			}
		}
	};

	// Ƿĳһ^УXrҪ^LӋrg@gһ푑|¼
	private boolean onProcessing() {
		return whoRun == -1;
	}

	// ĬJһ
	private int whoRun = 1;

	private void setPlayer1Run() {
		whoRun = 1;
	}

	private void setOnProcessing() {
		whoRun = -1;
	}

	// Ƿ݆
	private boolean isPlayer1Run() {
		return whoRun == 1;
	}

	// Ƿ݆
	private boolean isPlayer2Run() {
		return whoRun == 2;
	}

	private void setPlayer2Run() {
		whoRun = 2;
	}

	private void refressCanvas() {
		// |lonDraw
		Chessboard.this.invalidate();
	}

	private void drawPlayer1Point(Canvas canvas) {
		int size = player1.getMyPoints().size() - 1;
		if (size < 0) {
			return;
		}
		for (int i = 0; i < size; i++) {
			drawPoint(canvas, player1.getMyPoints().get(i), GREEN);
		}
		// µһc˳Sɫ
		drawPoint(canvas, player1.getMyPoints().get(size), NEW_GREEN);
	}

	private void drawPlayer2Point(Canvas canvas) {
		if (player2 == null) {
			return;
		}
		int size = player2.getMyPoints().size() - 1;
		if (size < 0) {
			return;
		}
		for (int i = 0; i < size; i++) {
			drawPoint(canvas, player2.getMyPoints().get(i), RED);
		}
		// µһc˳Sɫ
		drawPoint(canvas, player2.getMyPoints().get(size), NEW_RED);
	}

	// ʼNɫc
	public void fillPointArrays(int color, Drawable drawable) {
		Bitmap bitmap = Bitmap.createBitmap(pointSize, pointSize,
				Bitmap.Config.ARGB_8888);
		Canvas canvas = new Canvas(bitmap);
		drawable.setBounds(0, 0, pointSize, pointSize);
		drawable.draw(canvas);
		pointArray[color] = bitmap;
	}

	// doRunǿҊăȴ攵˷ݔԈDķʽFԮ֮ǰһҪȜʂ
	@Override
	protected void onDraw(Canvas canvas) {
		drawChssboardLines(canvas);
		// ڵc
		drawPlayer1Point(canvas);
		// Xµ
		drawPlayer2Point(canvas);
	}

	@Override
	public List<Point> getFreePoints() {
		return allFreePoints;
	}

	// ʼհc
	private void createPoints() {
		allFreePoints.clear();
		for (int i = 0; i < maxX; i++) {
			for (int j = 0; j < maxY; j++) {
				allFreePoints.add(new Point(i, j));
			}
		}
	}

	@Override
	public int getMaxX() {
		return maxX;
	}

	@Override
	public int getMaxY() {
		return maxY;
	}

}