package com.amaker.game.app;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.KeyEvent;
import android.view.View;

/**
 * 
 * @author 
 * CO
 */
public class GameView extends View implements Runnable{
	// aBitmap
	private Bitmap playerBitmap;
	// luBitmap
	private Bitmap bulletBitmap;
	// ĤHBitmap
	private Bitmap enemyBitmap;
	// a
	private Player player;
	// lu}C
	private Bullet[] bullets = new Bullet[3];
	// ĤH
	private Enemy enemy;
	// Context
	private Context context;
	// ùeB
	public int screenWidth,screenHeight;
	// zϤ
	public Bitmap exploreBitmap;
	// P_O_z
	private boolean isExplore;
	
	// غcl
	public GameView(Context context,int screenWidth,int screenHeight) {
		super(context);
		this.context = context;
		this.screenWidth = screenWidth;
		this.screenHeight = screenHeight;
		setFocusable(true);
	}
	// øsk
	@Override
	public void draw(Canvas canvas) {
		// ea
		player.paint(canvas);
		// elu
		for (int i = 0; i <bullets.length; i++) {
			bullets[i].draw(canvas);
		}
		// eĤH
		enemy.draw(canvas);
		
		if(isExplore){
			canvas.drawBitmap(exploreBitmap, enemy.getY(), enemy.getX(), null);
			isExplore = false;
			enemy.setAlive(false);
		}
		
		super.draw(canvas);
	}
	
	// Lƥ
	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		switch (keyCode) {
		case KeyEvent.KEYCODE_DPAD_UP:
			player.move(Player.UP);
			break;
		case KeyEvent.KEYCODE_DPAD_DOWN:
			player.move(Player.DOWN);
			break;
		case KeyEvent.KEYCODE_DPAD_LEFT:
			player.move(Player.LEFT);
			break;
		case KeyEvent.KEYCODE_DPAD_RIGHT:
			player.move(Player.RIGHT);
			break;
		case KeyEvent.KEYCODE_DPAD_CENTER:
			for (int i = 0; i < bullets.length; i++) {
				if(bullets[i].getAlive()==false){
					bullets[i].setAlive(true, 
							player.getRefPixelX()-bullets[i].getWidth()/2,
							player.getRefPixelY()-player.getHeight());
					break;
				}
			}
			break;
		}
		return super.onKeyDown(keyCode, event);
	}

	// k@
	public void run() {
		load();
		init();
		while(true){
			if(!enemy.isAlive()){
				enemy.setAlive();
			}
			tick();
			postInvalidate();
			try {
				Thread.sleep(100);
			} catch (InterruptedException e) {
			}
		}
	}
	
	// J귽
	public void load(){
		// oaϤ
		playerBitmap = GameHelper.getBitmap(context,R.drawable.player);
		// Ҥƪa
		player = new Player(playerBitmap,playerBitmap.getWidth(),playerBitmap.getHeight());
		// ]wùeM
		player.setScreenSize(screenWidth, screenHeight);
		// oluϤ
		bulletBitmap = GameHelper.getBitmap(context,R.drawable.bullet);
		
		exploreBitmap = GameHelper.getBitmap(context,R.drawable.explored);
		for(int i=0;i<bullets.length;i++){
			// ҤƤlu
			bullets[i] = new Bullet(bulletBitmap,bulletBitmap.getWidth(),bulletBitmap.getHeight());
			// ]wùeM
			bullets[i].setScreenSize(screenWidth, screenHeight);
		}
		// oĤHϤ
		enemyBitmap = GameHelper.getBitmap(context, R.drawable.e6);
		// ҤƼĤH
		enemy = new Enemy(enemyBitmap,enemyBitmap.getWidth(),enemyBitmap.getHeight());
		// ]wùeM
		enemy.setScreenSize(screenWidth, screenHeight);
	}
	
	// l
	public void init(){
		// lƪa
		player.init();
		for (int i = 0; i < bullets.length; i++) {
			bullets[i].setAlive(false);
		}
	}
	
	// Ұʰ
	public void start(){
		new Thread(this).start();
	}
	
	public void tick(){
		for (int i = 0; i < bullets.length; i++) {
			bullets[i].move();
			if(bullets[i].collidesWith(enemy, false)){
				isExplore = true;
			}
		}
		enemy.move();
		
	}
}
