package com.amaker.game.app;

import android.graphics.Bitmap;
import com.amaker.game.Sprite;

/**
 * 
 * @author 
 * a@O
 */
public class Player extends Sprite{
	// wqùeM
	private int screenWidth,screenHeight;
	// wqaeM
	private int frameWidth,frameHeight;
	// wqaO_٬
	private boolean isAlive = false;
	// wqʤV`ơAWBUBBk
	public static final int UP = 1;
	public static final int DOWN = 2;
	public static final int LEFT = 3;
	public static final int RIGHT = 4;
	// wqʳt
	public static int SPEED = 4;
	
	// غcl
	public Player(Bitmap Bitmap,int frameWidth,int frameHeight) {
		super(Bitmap);
		this.frameWidth = frameWidth;
		this.frameHeight = frameHeight;
		defineReferencePixel(frameWidth/2, frameHeight/2);
	}
	// ]wùjp
	public void setScreenSize(int screenWidth,int screenHeight){
		this.screenHeight = screenHeight;
		this.screenWidth = screenWidth;
	}
	// Ұʪa
	public void setAlive(boolean isAlive){
		this.isAlive = isAlive;
		setPosition(screenWidth/2, screenHeight/2);
	}
	// oasA
	public boolean getAlive(){
		return this.isAlive;
	}
	// ʪa
	public void move(int direction){
		// VW
		if(direction==UP){
			move(0, -SPEED);
			if(getY()<0){
				setPosition(getX(), 0);
			}
		}
		// VU
		if(direction==DOWN){
			move(0, SPEED);
			if(getY()>screenHeight-frameHeight){
				setPosition(getX(), screenHeight-frameHeight);
			}
		}
		
		// V
		if(direction==LEFT){
			move(-SPEED, 0);
			if(getX()<0){
				setPosition(0, getY());
			}
		}
		// Vk
		if(direction==RIGHT){
			move(SPEED, 0);
			if(getX()>screenWidth-frameWidth){
				setPosition(screenWidth-frameWidth,getY());
			}
		}
	}
	// lƪa
	public void init(){
		SPEED = 4;
		setAlive(true);
	}
}
