package com.amaker.game.app;

import java.util.Random;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.amaker.game.Sprite;
/**
 * @author 
 * ĤHϼhO
 */
public class Enemy extends Sprite {
	// wqĤHeM
	private int frameWidth, frameHeight;
	// wqùeM
	private int screenWidth,screenHeight;
	// P_ĤHO_s
	private boolean isAlive;
	// ü
	Random r;
	public Enemy(Bitmap Bitmap, int frameWidth, int frameHeight) {
		super(Bitmap, frameWidth, frameHeight);
		this.frameWidth = frameWidth;
		this.frameHeight = frameHeight;
		defineReferencePixel(frameWidth / 2, frameHeight / 2);
		r = new Random();
	}
	// ]wùeM
	public void setScreenSize(int screenWidth,int screenHeight){
		this.screenHeight = screenHeight;
		this.screenWidth = screenWidth;
	}
	
	// ]wĤHs
	public void setAlive(){
		isAlive = true;
		int x = (r.nextInt() & 0x7fffffff)%(screenWidth-frameWidth);
		setPosition(x,0);
	}
	
	public void setAlive(boolean alive){
		this.isAlive = alive;
	}
	// 
	public void move(){
		if(isAlive){
			move(0, 3);
			if(getY()>screenHeight){
				isAlive=false;
			}
		}
	}
	
	public boolean isAlive(){
		return isAlive;
	}
	// øsĤH
	public void draw(Canvas canvas){
		if(isAlive){
			paint(canvas);
		}
	}

}
