package tw.edu.hust.bn98000;

import android.R.color;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;

public class GameView2 extends SurfaceView {
	private Ball b1 = new Ball(240, 350, 15, 7, 5, Color.YELLOW);
	private Bar bar = new Bar( 150, 410, 80, 20, Color.BLUE);
	private Block block = new Block( 40, 80, 80, 20, Color.YELLOW);
	private Paint bgPen = new Paint();
	private int width=320;
	private int height=480;

	// 
	public GameView2(Context context) {
		super(context);

		
		// TODO Auto-generated constructor stub

	}

	public GameView2(Context context, AttributeSet attrs) {
		super(context, attrs);
		// TODO Auto-generated constructor stub
	}

	public GameView2(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
		// TODO Auto-generated constructor stub
	}

	//

	@Override
	protected void onDraw(Canvas canvas) {
		// TODO Auto-generated method stub
		super.onDraw(canvas);
		bgPen.setColor(color.white);
		bgPen.setAlpha(0xFF);
		canvas.drawRect(0, 0, this.getWidth(), this.getHeight(), bgPen);
		b1.draw(canvas);
		bar.draw(canvas);
		block.draw(canvas);
	}

	@Override
	protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
		// TODO Auto-generated method stub
		super.onMeasure(widthMeasureSpec, heightMeasureSpec);				
		this.width = MeasureSpec.getSize(widthMeasureSpec);
		this.height = MeasureSpec.getSize(heightMeasureSpec);
		if (bar != null) bar.setSize( width, height);
		setMeasuredDimension( width, height);
	}
	

	int x1, y1;
	int x2, y2;
	private boolean drag;
	@Override
	public boolean onTouchEvent(MotionEvent event) {
		// TODO Auto-generated method stub
		switch ( event.getAction() ) {
          case MotionEvent.ACTION_DOWN: 
        	  int x = (int )event.getX();
        	  int y = (int) event.getY();
        	  if (bar.getRect().contains(x, y))
        		  drag = true ;
        	  else
        		  drag = false;
        	break;
          case MotionEvent.ACTION_MOVE: 
        	  if (drag){
        		  int nx = (int)event.getX();
        		  bar.moveCenterToPos(nx);
        	  }
        	break;
          case MotionEvent.ACTION_UP:     
        	 drag =  false;
        	break;
		}
		//
		return true;
	}

	public void moveBall(SurfaceHolder sHolder) {
		// TODO Auto-generated method stub
		b1.move(this.getWidth(), this.getHeight(), block, bar);
		Canvas cc = sHolder.lockCanvas();
		if (cc == null) return ;
		onDraw(cc);
		sHolder.unlockCanvasAndPost(cc);
	}	
}
