/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package bn99000hw0401;

import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

/**
 *
 * @author teacher
 */
public class PinPonUI extends javax.swing.JFrame {
    static final int GP_WIDTH = 640;
    static final int GP_HEIGHT = 600;
    private  MyTimer timer;
    private GamePanel gp = new GamePanel( GP_WIDTH , GP_HEIGHT);
    /**
     * Creates new form PinPonUI
     */
    public PinPonUI() {
        initComponents();
        //
        //this.setLayout( new BorderLayout());
        gp.setPreferredSize(new Dimension(GP_WIDTH , GP_HEIGHT) );
        this.add(gp);
        this.pack();
        //
    }

    public void startGame() {
        // 若有舊的計時執行緒，必須先停掉!!
        if (timer != null && timer.isAlive())
            timer.stopRun();

        // 初始化遊戲畫面, "" --> 表示無磚塊設定檔
        gp.startGame(""); 
        // 啟動新的執行緒來計時。
        timer = new MyTimer();
        timer.setName("計時Timer");
        timer.start();
    }

   public void stopGame() {
        timer.stopRun();
        gp.stopGame(); // set running = false;
    }

    class MyTimer extends Thread{
        private boolean running=true;
        public void run() {
            // 改變按鈕狀態!!
            btnStart.setEnabled(false);
            btnStop.setEnabled(true);
            btnChangeLevel.setEnabled(false);
            // 開始時間(tt1) !!
            long tt1 = System.currentTimeMillis();
            // 檢查是否仍在進行遊戲 ??
            while ( running ){
                long tt2 = System.currentTimeMillis();
                int sec =(int)(tt2 - tt1) / 1000;
                jlTimer.setText( String.format("%3d秒  ", sec) );
                //
                if (gp.isGameOver()) {
                    JOptionPane.showMessageDialog( null, "可惜，闖關失敗!!!!!");
                    break;
                }
                 else if (gp.isGamePass())  {
                    JOptionPane.showMessageDialog( null, "恭喜，你過關了!!!!!");
                    break;
                }
                // 睡一下 ....
                try {
                    sleep(300);
                } catch (InterruptedException ex) {
                    Logger.getLogger(PinPonUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            // 還原按鈕狀態!!
            btnStart.setEnabled(true);
            btnStop.setEnabled(false);
            btnChangeLevel.setEnabled(true);
        }
        //
        public void stopRun() {
            running = false;
        }
    }
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jlTimer = new javax.swing.JLabel();
        btnStart = new javax.swing.JButton();
        btnStop = new javax.swing.JButton();
        btnChangeLevel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jPanel1.setBackground(new java.awt.Color(153, 153, 153));

        jLabel1.setText("經過秒數：");
        jPanel1.add(jLabel1);

        jlTimer.setText("0秒");
        jPanel1.add(jlTimer);

        btnStart.setText("開始");
        btnStart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnStartActionPerformed(evt);
            }
        });
        jPanel1.add(btnStart);

        btnStop.setText("停止");
        btnStop.setEnabled(false);
        btnStop.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnStopActionPerformed(evt);
            }
        });
        jPanel1.add(btnStop);

        btnChangeLevel.setText("選擇關卡");
        btnChangeLevel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnChangeLevelActionPerformed(evt);
            }
        });
        jPanel1.add(btnChangeLevel);

        getContentPane().add(jPanel1, java.awt.BorderLayout.PAGE_START);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btnChangeLevelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnChangeLevelActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_btnChangeLevelActionPerformed

    private void btnStartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnStartActionPerformed
        // TODO add your handling code here:
        btnStart.setText("重新開始");
        startGame();
    }//GEN-LAST:event_btnStartActionPerformed

    private void btnStopActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnStopActionPerformed
        // TODO add your handling code here:
        stopGame();
    }//GEN-LAST:event_btnStopActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /*
         * Set the Nimbus look and feel
         */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /*
         * If Nimbus (introduced in Java SE 6) is not available, stay with the
         * default look and feel. For details see
         * http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(PinPonUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(PinPonUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(PinPonUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(PinPonUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /*
         * Create and display the form
         */
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new PinPonUI().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnChangeLevel;
    private javax.swing.JButton btnStart;
    private javax.swing.JButton btnStop;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel jlTimer;
    // End of variables declaration//GEN-END:variables
}
