/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package bn99000hw0401;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

/**
 *
 * @author teacher
 */
public class GamePanel extends javax.swing.JPanel {
    // 遊戲畫面的初始大小!!
    int width=640, height = 480;
    //
    Ball ball;
    Vector<Block> blocks = new Vector<Block>();
    Bar bar;
    // 遊戲 Thread - 控制球的移動!!
    private GameThread  gameThread;

    /**
     * Creates new form GamePanel
     */
    public GamePanel(int width, int height) {
        // 0. 初始化畫面
        initComponents();
        this.width = width;
        this.height = height;
        // 1. 註冊檔板控制的按鍵與處理程式
        addKeyActionListener();
        // 2. 初始化磚塊, 一開始以基本設定為主 !
        initialSetting( "");
        // 3. 更新畫面
        this.repaint();
    }

    public void initialSetting(String fname ){
        // 1. 產生一顆球
        ball = new Ball( width/2, height/2, 15, -5, -5, Color.RED);
        // 2. 產生檔板
        bar = new Bar( width/2-40 , height-20, 80, 20);
        
        // 3. 產生磚塊 !
        // 3-1. 先將 blocks 容器中的舊磚塊清除
        blocks.clear();
        // case A, 無傳入檔案名稱，直接產生練習用磚塊
         if (fname.length() == 0 ) {
                for (int i=0; i<5; i++) {
                    Block bb = new Block( 100+i*80, 20, 80, 30, Color.GREEN);
                    blocks.add(bb);
                  }
                 for (int i=0; i<6; i++) {
                     Block bb = new Block(60+i*80, 20+30, 80, 30, Color.PINK);
                    blocks.add(bb);
                  }
           }
         // case B, 有傳入檔案名稱，利用設定檔方式來生成磚塊!
          else {
               // 請同學們完成!!
          }
    }

    public void startGame(String settingFile) {
        // 0. 檢查先前是否有 gameThread 還在 [執行中] ?
        if (gameThread != null && gameThread.isAlive() )
            gameThread.stopRun();
        // ----------------------------- 初始化遊戲 !!
        // 1. 產生一顆球
        ball = new Ball( width/2, height/2, 15, -5, -5, Color.RED);
        // 2. 初始化磚塊, 一開始以基本設定為主 !
        initialSetting(settingFile);
        // 3. 產生檔板
        bar = new Bar( width/2-40 , height-20, 80, 20);
        // 4. 更新畫面
        this.repaint();
        // 5. 啟動遊戲執行緒 --> 移動球!
        gameThread  = new GameThread();
        gameThread.setName("Game Thread");
        gameThread.start();
    }

    public void stopGame( ) {
        // 讓執行緒停止執行!!
        if (gameThread != null && gameThread.isAlive() )
            gameThread.stopRun();
    }

    // 檢查認遊戲是否過關 ?
    public boolean isGamePass() {
        if (blocks.isEmpty())
            return true;
        else
            return false;
    }

    // 檢查遊戲是否闖關失敗 ==> 由[球]的狀態來決定
    public boolean isGameOver() {
        return ball.isDead();
    }

    // 檢查遊戲是否繼續進行?
    public boolean isRunning() {
         return (isGameOver() == false) && ( isGamePass()==false);
    }

    // 獨立宣告的Thread 的子類別 - GameThread
    class GameThread extends Thread {
           private boolean running = true;
           public void run() {
               while(running == true) {
                   ball.move( blocks, bar, GamePanel.this.getWidth(), GamePanel.this.getHeight());
                   repaint();
                   // 檢查是否過關? 或死掉?
                   if (isGameOver() || isGamePass()) {
                       // 停止球的移動與畫面繪製!!
                       break;
                   }
                   //
                   try {
                        sleep(50);
                    } catch (InterruptedException ex) {
                        // nothing to do !
                    }
               }
           }
           //

           public void stopRun() {
               running = false;
           }
    }

    public void addKeyActionListener() {
        //  方法 I : 利用 registerKeyboardAction (JDK 1.2 )
        KeyStroke left_key = KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 0, false);
        KeyStroke right_key = KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 0, false);

        // 註冊 <LEFT> 按鍵處理程式
        this.registerKeyboardAction(
                new ActionListener() {

                    public void actionPerformed(ActionEvent e) {
                        processKey(KeyEvent.VK_LEFT);
                    }
                }, left_key, JComponent.WHEN_IN_FOCUSED_WINDOW);
        // 註冊 <Right> 按鍵處理程式
        this.registerKeyboardAction(
                new ActionListener() {

                    public void actionPerformed(ActionEvent e) {
                        processKey(KeyEvent.VK_RIGHT);
                    }
                }, right_key, JComponent.WHEN_IN_FOCUSED_WINDOW);
    }

// ＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝＝
    private void processKey(int keyCode) {
        switch (keyCode) {
            case KeyEvent.VK_LEFT:
                //JOptionPane.showMessageDialog( this, " (按下左鍵)" );
                bar.moveLeft();
                break;
            case KeyEvent.VK_RIGHT:
                //JOptionPane.showMessageDialog( this, " (按下右鍵)" );
                bar.moveRight();
                break;
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics gr) {
        // 呼叫 JPanel 初始化畫面
        super.paintComponent(gr);
        // 畫出新的畫面內容!
        gr.setColor(Color.YELLOW);
        gr.fillRect(0, 0, this.getWidth(), this.getHeight());
        //
        if (ball != null) ball.draw(gr);
        //bb.draw(gr);
        drawBlocks(gr);
        if (bar != null) bar.draw(gr);
    }

    
     // 新的方法 - 畫出所有磚塊----------------------
    private void drawBlocks(Graphics gr) {
        if (blocks == null) return;
         Iterator<Block> it = blocks.iterator();
         while (it.hasNext()) {
              Block bb = it.next();
             bb.draw(gr);
        }
    }
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
