/*
 * Decompiled with CFR 0.152.
 */
package bn99000hw0401;

import bn99000hw0401.Ball;
import bn99000hw0401.Bar;
import bn99000hw0401.Block;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class GamePanel
extends JPanel {
    int width = 640;
    int height = 480;
    Ball ball;
    Vector<Block> blocks = new Vector();
    Bar bar;
    private GameThread gameThread;

    public GamePanel(int width, int height) {
        this.initComponents();
        this.width = width;
        this.height = height;
        this.addKeyActionListener();
        this.initialSetting("");
        this.repaint();
    }

    public void initialSetting(String fname) {
        this.ball = new Ball(this.width / 2, this.height / 2, 15, -5, -5, Color.RED);
        this.bar = new Bar(this.width / 2 - 40, this.height - 20, 80, 20);
        this.blocks.clear();
        if (fname.length() == 0) {
            Block bb;
            int i;
            for (i = 0; i < 5; ++i) {
                bb = new Block(100 + i * 80, 20, 80, 30, Color.GREEN);
                this.blocks.add(bb);
            }
            for (i = 0; i < 6; ++i) {
                bb = new Block(60 + i * 80, 50, 80, 30, Color.PINK);
                this.blocks.add(bb);
            }
        }
    }

    public void startGame(String settingFile) {
        if (this.gameThread != null && this.gameThread.isAlive()) {
            this.gameThread.stopRun();
        }
        this.ball = new Ball(this.width / 2, this.height / 2, 15, -5, -5, Color.RED);
        this.initialSetting(settingFile);
        this.bar = new Bar(this.width / 2 - 40, this.height - 20, 80, 20);
        this.repaint();
        this.gameThread = new GameThread();
        this.gameThread.setName("Game Thread");
        this.gameThread.start();
    }

    public void stopGame() {
        if (this.gameThread != null && this.gameThread.isAlive()) {
            this.gameThread.stopRun();
        }
    }

    public boolean isGamePass() {
        return this.blocks.isEmpty();
    }

    public boolean isGameOver() {
        return this.ball.isDead();
    }

    public boolean isRunning() {
        return !this.isGameOver() && !this.isGamePass();
    }

    public void addKeyActionListener() {
        KeyStroke left_key = KeyStroke.getKeyStroke(37, 0, false);
        KeyStroke right_key = KeyStroke.getKeyStroke(39, 0, false);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GamePanel.this.processKey(37);
            }
        }, left_key, 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GamePanel.this.processKey(39);
            }
        }, right_key, 2);
    }

    private void processKey(int keyCode) {
        switch (keyCode) {
            case 37: {
                this.bar.moveLeft();
                break;
            }
            case 39: {
                this.bar.moveRight();
            }
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        gr.setColor(Color.YELLOW);
        gr.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.ball != null) {
            this.ball.draw(gr);
        }
        this.drawBlocks(gr);
        if (this.bar != null) {
            this.bar.draw(gr);
        }
    }

    private void drawBlocks(Graphics gr) {
        if (this.blocks == null) {
            return;
        }
        for (Block bb : this.blocks) {
            bb.draw(gr);
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    class GameThread
    extends Thread {
        private boolean running = true;

        GameThread() {
        }

        @Override
        public void run() {
            while (this.running) {
                GamePanel.this.ball.move(GamePanel.this.blocks, GamePanel.this.bar, GamePanel.this.getWidth(), GamePanel.this.getHeight());
                GamePanel.this.repaint();
                if (GamePanel.this.isGameOver() || GamePanel.this.isGamePass()) break;
                try {
                    GameThread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void stopRun() {
            this.running = false;
        }
    }
}

