/*
 * Decompiled with CFR 0.152.
 */
package bn99000hw0401;

import bn99000hw0401.Bar;
import bn99000hw0401.Block;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

public class Ball {
    int x;
    int y;
    int r;
    int vx;
    int vy;
    Color color;
    private boolean isDead = false;

    public Ball(int x, int y, int r, int vx, int vy, Color cc) {
        this.x = x;
        this.y = y;
        this.r = r;
        this.vx = vx;
        this.vy = vy;
        this.color = cc;
    }

    public void draw(Graphics gr) {
        gr.setColor(this.color);
        gr.fillOval(this.x - this.r, this.y - this.r, 2 * this.r, 2 * this.r);
    }

    public boolean isDead() {
        return this.isDead;
    }

    void move(Vector<Block> blocks, Bar bar, int width, int height) {
        this.x += this.vx;
        this.y += this.vy;
        if (this.x <= this.r) {
            this.vx = -this.vx;
        } else if (this.x >= width - this.r) {
            this.vx = -this.vx;
        }
        Rectangle rect1 = this.getRect();
        Rectangle rect3 = bar.getRect();
        if (rect1.intersects(rect3)) {
            this.vy = -this.vy;
        }
        if (this.isCollision(rect1, blocks)) {
            this.vy = -this.vy;
        }
        if (this.y <= this.r) {
            this.vy = -this.vy;
        } else if (this.y >= height - this.r) {
            this.isDead = true;
        }
    }

    private Rectangle getRect() {
        return new Rectangle(this.x - this.r, this.y - this.r, 2 * this.r, 2 * this.r);
    }

    private boolean isCollision(Rectangle rect1, Vector<Block> blocks) {
        for (Block bb : blocks) {
            Rectangle rr = bb.getRect();
            if (!rect1.intersects(rr)) continue;
            blocks.remove(bb);
            return true;
        }
        return false;
    }
}

