package COM.TQC.GDD02;

import java.text.DecimalFormat;
import android.app.Activity;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

public class GDD02 extends Activity implements OnClickListener {
	public static final String reat = "ײv" ;
    private Button calcbutton ;
	private EditText fieldExchangeRate ;
	private EditText fieldNTD ;
	private TextView tvResult;
	
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
    	
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        //
        fieldExchangeRate = (EditText)findViewById(R.id.edRate);
        fieldNTD = (EditText)findViewById(R.id.edNTD);
        calcbutton = (Button)findViewById(R.id.btnSumbit);
        tvResult = (TextView)findViewById(R.id.tvResult);
        calcbutton.setOnClickListener(this);
    }
    
    public void onPause() {
    	super.onPause() ;
    	SharedPreferences settings = getSharedPreferences(reat, 0);
    	settings.edit().putString(reat, fieldExchangeRate.getText().toString()).commit() ;
    	
    }
    
    public void onResume() {
    	super.onResume();
       	SharedPreferences settings = getSharedPreferences(reat, 0);
       	String rate = settings.getString(reat, "");
       	fieldExchangeRate.setText(rate);
    }

	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		double rate = Double.parseDouble( fieldExchangeRate.getText().toString());
	    double nt = Double.parseDouble( fieldNTD.getText().toString());
	    double result = nt / rate;
	    String msg = this.getResources().getString(R.string.usd_result);
	    msg += String.format("%.2f", result);
	    tvResult.setText(msg);
	    
	}

}

