package tw.edu.hust.bn98047;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

public class EchoClient extends Activity implements OnClickListener {
	/** Called when the activity is first created. */
	private EditText edServer, edDat;
	private TextView tvResult;
	private Button btnConnect, btnDisconnect, btnSend;
	private BufferedWriter bw;
	private BufferedReader br;
	private Socket cs;
	private InputStream in;
	private OutputStream out;
	MyHandler handler = new MyHandler();// PB

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		edServer = (EditText) findViewById(R.id.edServer);
		edDat = (EditText) findViewById(R.id.edData);
		tvResult = (TextView) findViewById(R.id.tvResult);
		btnConnect = (Button) findViewById(R.id.btnConnect);
		btnDisconnect = (Button) findViewById(R.id.btnDisconnect);
		btnSend = (Button) findViewById(R.id.btnSend);
		//
		btnConnect.setOnClickListener(this);
		btnSend.setOnClickListener(this);
		btnDisconnect.setOnClickListener(this);
		//
	}

	@Override
	public void onClick(View v) { // Button O
		// TODO Auto-generated method stub
		switch (v.getId()) {
		case R.id.btnConnect:
			Connect();
			break;
		case R.id.btnDisconnect:
			Disconnect();
			break;
		case R.id.btnSend:
			Send();
			break;
		}
	}

	/* 䱱 */
	private void Connect() {
		// TODO Auto-generated method stub
		try {
			cs = new Socket("entry.hust.edu.tw", 7);
			in = cs.getInputStream();// Gi
			out = cs.getOutputStream();
			br = new BufferedReader(new InputStreamReader(in));
			bw = new BufferedWriter(new OutputStreamWriter(out));
			Toast.makeText(this, "su\", Toast.LENGTH_LONG).show();
			// ťŪJ
			new Thread() {
				@Override
				public void run() {
					// TODO Auto-generated method stub
					while (true) {
						try {
							String data = br.readLine();
							Bundle data2 = new Bundle();
							data2.putString("ECHO",data);
							Message msg = new Message();
							msg.setData(data2);
							handler.sendMessage(msg);

							// tvResult.setText(data + "\n");
							// Log.i("jj", "kk");
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				}

			}.start();

		} catch (UnknownHostException e) { // DB䤣 D
			// TODO Auto-generated catch block
			Toast.makeText(this, "Dsu", Toast.LENGTH_LONG).show();
			e.printStackTrace();

		} catch (IOException e) { // JX~
			// TODO Auto-generated catch block
			Toast.makeText(this, "I/O~", Toast.LENGTH_LONG).show();
			e.printStackTrace();
		}

	}

	private void Disconnect() {
		// TODO Auto-generated method stub
		try {
			cs.close();// _u
			Toast.makeText(this, "_u\", Toast.LENGTH_LONG).show();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			Toast.makeText(this, "~", Toast.LENGTH_LONG).show();
			e.printStackTrace();
		}
	}

	private void Send() {
		// TODO Auto-generated method stub
		String msg = edDat.getText().toString();
		try {
			bw.write(msg + "\n");
			bw.flush();
			//cs.close();// _u
			Toast.makeText(this, "ǰe\", Toast.LENGTH_LONG).show();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	class MyHandler extends Handler {
		@Override
		public void handleMessage(Message msg) {
			// TODO Auto-generated method stub
			super.handleMessage(msg);
			tvResult.append(msg.getData().getString("ECHO")+"\n");
		}

	}
}