package tw.hust.BN98027;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

public class Echo extends Activity implements OnClickListener {
	EditText eT1, eT2;
	Button B1, B2, B3;
	TextView Tv;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		//
		eT1 = (EditText) findViewById(R.id.eT1);
		eT2 = (EditText) findViewById(R.id.eT2);
		B1 = (Button) findViewById(R.id.B1);
		B2 = (Button) findViewById(R.id.B2);
		B3 = (Button) findViewById(R.id.B3);
		Tv = (TextView) findViewById(R.id.Tv1);

		B1.setOnClickListener(this);
		B2.setOnClickListener(this);
		B3.setOnClickListener(this);

	}

	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		switch (v.getId()) {
		case R.id.B1:
			Connect();
			break;
		case R.id.B3:
			Disconnect();
			break;
		case R.id.B2:
			Send();
			break;
		}

	}

	private void Send() {
		// TODO Auto-generated method stub
		String msg = eT2.getText().toString();
		try {
			wr.write(msg + "\n");
			wr.flush();
			Toast.makeText(this, "ǰe\!", Toast.LENGTH_LONG).show();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private void Disconnect() {
		// TODO Auto-generated method stub
		try {
			cs.close();
			Toast.makeText(this, "_u\", Toast.LENGTH_LONG).show();
		} catch (IOException e) {
			Toast.makeText(this, "", Toast.LENGTH_LONG).show();
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	MyHandler handler = new MyHandler();
	Socket cs;
	BufferedReader br;
	BufferedWriter wr;

	private void Connect() {
		// TODO Auto-generated method stub
		try {
			cs = new Socket("entry.hust.edu.tw", 7);
			InputStream in = cs.getInputStream();
			OutputStream out = cs.getOutputStream();
			br = new BufferedReader(new InputStreamReader(in));
			wr = new BufferedWriter(new OutputStreamWriter(out));
			Toast.makeText(this, "su\", Toast.LENGTH_LONG).show();
			new Thread() {

				@Override
				public void run() {
					// TODO Auto-generated method stub
					while (true) {

						try {
							String data = br.readLine();
							//Tv.append(data + "\n");
							Bundle bb =new Bundle();
							bb.putString("echo", data);
							Message msg = new Message();
							msg.setData(bb);
							handler.sendMessage(msg);
							
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				}

			}.start();
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			Toast.makeText(this, "", Toast.LENGTH_LONG).show();
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			Toast.makeText(this, "", Toast.LENGTH_LONG).show();
			e.printStackTrace();
		}

	}

	class MyHandler extends Handler {

		@Override
		public void handleMessage(Message msg) {
			// TODO Auto-generated method stub
			super.handleMessage(msg);
			Tv.append(msg.getData().getString("echo"));
		}

	}
}
