package tw.edu.hust.bn98108;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

public class EchoClient extends Activity implements OnClickListener {
	EditText edServer, edData;
	Button btnConnect, btnDisconnect, btnSend;
	TextView tvResult;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		edServer = (EditText) findViewById(R.id.edServer);
		edData = (EditText) findViewById(R.id.edData);
		btnConnect = (Button) findViewById(R.id.btnConnect);
		btnDisconnect = (Button) findViewById(R.id.btnDisconnect);
		btnSend = (Button) findViewById(R.id.btnSend);
		tvResult = (TextView) findViewById(R.id.tvResult);
		//
		btnConnect.setOnClickListener(this);
		btnSend.setOnClickListener(this);
		btnDisconnect.setOnClickListener(this);

	}

	@Override
	public void onClick(View arg0) {
		// TODO Auto-generated method stub
		switch (arg0.getId()) {
		case R.id.btnConnect:
			connect();
			break;
		case R.id.btnSend:
			send();
			break;
		case R.id.btnDisconnect:
			disconnnent();
			break;
		}

	}

	private void disconnnent() {
		// TODO Auto-generated method stub
		try {
			cs.close();
			Toast.makeText(this, "_u\!!", Toast.LENGTH_SHORT).show();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	private void send() {
		// TODO Auto-generated method stub

		String msg = edData.getText().toString();
		try {
			bw.write(msg + "\n");
			bw.flush();
			Toast.makeText(this, "ǰe\!!", Toast.LENGTH_SHORT).show();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	MyHandler hanlder = new MyHandler();
	Socket cs;
	BufferedWriter bw;
	BufferedReader br;

	private void connect() {
		// TODO Auto-generated method stub
		try {
			cs = new Socket("entry.hust.edu.tw", 7);
			InputStream in = cs.getInputStream();
			OutputStream out = cs.getOutputStream();
			br = new BufferedReader(new InputStreamReader(in));
			bw = new BufferedWriter(new OutputStreamWriter(out));
			Toast.makeText(this, "su\", Toast.LENGTH_SHORT).show();
			// BzJThread!!
			new Thread() {

				@Override
				public void run() {
					//
					while (true) {
						try {
							String data = br.readLine();
							// tvResult.append(data + "\n");
							Bundle bb = new Bundle();
							bb.putString("ECHO", data);
							Message msg = new Message();
							msg.setData(bb);
							hanlder.sendMessage(msg);
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				}

			}.start();

		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block

			Toast.makeText(this, "DWٿ~", Toast.LENGTH_LONG).show();
			e.printStackTrace();

		} catch (IOException e) {
			// TODO Auto-generated catch block
			Toast.makeText(this, "IO~", Toast.LENGTH_LONG).show();
			e.printStackTrace();

		}
	}

	class MyHandler extends Handler {

		@Override
		public void handleMessage(Message msg) {
			// TODO Auto-generated method stub
			super.handleMessage(msg);
			tvResult.append(msg.getData().getString("ECHO")+"\n");
		}

	}
}
