package tw.edu.hust.android.ch04;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;

public class ActivityLifecycle extends Activity {
	private final String MARKER="ActivityLifecycle";
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
		Log.i( MARKER, "onCreate() called.");
        setContentView(R.layout.main);
        //
        Button btnS = (Button) findViewById(R.id.btnSearch);
        btnS.setOnClickListener( new Button.OnClickListener() {			
			public void onClick(View v) {
				// TODO Auto-generated method stub
		        Intent it = new Intent( Intent.ACTION_VIEW);
		        it.setData( Uri.parse( "http://www.google.com"));
		        startActivity( it);				
			}
		});
        Button btnD = (Button) findViewById(R.id.btnDialog);
        btnD.setOnClickListener( new Button.OnClickListener() {
			public void onClick(View v) {
				// TODO Auto-generated method stub
				Intent it = new Intent(ActivityLifecycle.this, DialogActivity.class);
				startActivity( it );
			}
		});
        Button btnQ = (Button) findViewById(R.id.btnQuit);
        btnQ.setOnClickListener( new Button.OnClickListener() {			
			public void onClick(View v) {
				// TODO Auto-generated method stub
				ActivityLifecycle.this.finish();				
			}
		});
    }

	@Override
	protected void onDestroy() {
		super.onDestroy();
		Log.i( MARKER, "onDestroy() called.");
	}

	@Override
	protected void onPause() {
		super.onPause();
		Log.i( MARKER, "onPause() called.");
	}

	@Override
	protected void onRestart() {
		super.onRestart();
		Log.i( MARKER, "onRestart() called.");
	}

	@Override
	protected void onResume() {
		super.onResume();
		Log.i( MARKER, "onResume() called.");
	}

	@Override
	protected void onStart() {
		super.onStart();
		Log.i( MARKER, "onStart() called.");
	}

	@Override
	protected void onStop() {
		super.onStop();
		Log.i( MARKER, "onStop() called.");
	}
	
}